//
//  GSLayer+PathOperations.h
//  GlyphsCoreMini
//
//  Created by Georg Seifert on 31/01/2017.
//  Copyright © 2017 schriftgestaltung.de. All rights reserved.
//

#import <GlyphsCore/GSLayer.h>

typedef NS_ENUM(NSInteger, GSPathOperationOptions) {
	GSPathOperationOptionCheckSelection = 1 << 0,
	GSPathOperationOptionKeepOpenPath = 1 << 1,
	GSPathOperationOptionCompatible = 1 << 2,
};

@interface GSLayer (PathOperations)

- (BOOL)removeOverlapCheckSelection:(BOOL)checkSelection error:(out NSError **)error;
- (BOOL)removeOverlapCheckSelection:(BOOL)checkSelection keepOpenPaths:(BOOL)keepOpenPaths gridSize:(CGFloat)gridSize error:(out NSError **)error;

- (BOOL)removeOverlap:(GSPathOperationOptions)options gridSize:(CGFloat)gridSize error:(out NSError **)error;

- (BOOL)pathSubtract:(out NSError **)error;
- (BOOL)pathSubtractKeepOverlaps:(BOOL)keepOverlaps error:(out NSError **)error;
- (BOOL)pathSubtract:(NSMutableArray *)selectedPaths from:(NSMutableArray *)notSelectedPaths keepOverlaps:(BOOL)keepOverlaps error:(out NSError **)error;

- (BOOL)pathIntersect:(out NSError **)error;
- (BOOL)pathIntersectCheckSelection:(BOOL)checkSelection error:(out NSError **)error;

@end
